<?php
// api/get_stats.php
header('Content-Type: application/json');
require 'db.php';

$user_name = $_GET['user_name'] ?? 'guest';

try {
    // Get total correct and total answered per app
    $sql = "SELECT 
                app_id, 
                COUNT(*) as total_answered, 
                SUM(CASE WHEN is_correct = 1 THEN 1 ELSE 0 END) as total_correct 
            FROM user_progress 
            WHERE user_name = ? 
            GROUP BY app_id";
            
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$user_name]);
    $stats = $stmt->fetchAll();
    
    echo json_encode(['success' => true, 'stats' => $stats]);

} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
